# Financial Leads CRM — v2
### Complete cPanel Deployment & User Guide

---

## Quick Start (New Install)

### Step 1 — Upload Files
Upload the entire `crm/` folder to your server:
- **cPanel File Manager**: Upload the ZIP → Extract to `public_html/`
- **FTP**: Upload the `crm/` folder to `public_html/crm/`

### Step 2 — Create a MySQL Database
In cPanel → **MySQL Database Wizard**:
1. Create a new database (e.g. `mysite_crm`)
2. Create a new user (e.g. `mysite_crmuser`) with a strong password
3. Grant the user **ALL PRIVILEGES** on the database

### Step 3 — Run the Installer
Navigate to: `http://yourdomain.com/crm/install/install.php`

Fill in:
- Database host: `localhost`
- Database name/user/password: from Step 2
- App URL path: `/crm` (or whatever folder you uploaded to)
- Admin email + password

Click **Install CRM**. The installer writes `config/config.php` and imports the schema automatically.

### Step 4 — Delete the Install Folder
⚠️ **Important security step** — delete or rename the `install/` folder after successful setup:
- In cPanel File Manager: right-click `install/` → Delete

### Step 5 — Login
Go to `http://yourdomain.com/crm/` and log in with your admin credentials.

---

## Upgrading from v1

If you have an existing v1 installation:

1. **Backup your database** first (phpMyAdmin → Export)
2. Upload the new files (overwrite everything except `config/config.php`)
3. Run the migration SQL in phpMyAdmin:
   - Open `install/migrate_v1_to_v2.sql`
   - Copy/paste into phpMyAdmin → SQL tab → Execute

---

## File Structure

```
crm/
├── index.php                  ← Login page (entry point)
├── .htaccess                  ← Security rules, PHP settings
├── README.md                  ← This file
│
├── config/
│   └── config.php             ← DB credentials + app settings (auto-written by installer)
│
├── includes/
│   ├── db.php                 ← PDO database singleton
│   ├── auth.php               ← Session management, login/logout, role checks, audit()
│   ├── helpers.php            ← Utility functions, custom field helpers, CSV export
│   ├── layout_header.php      ← HTML head, sidebar, topbar — shared by all pages
│   └── layout_footer.php      ← Closing Bootstrap JS tags
│
├── modules/
│   ├── auth/
│   │   ├── logout.php
│   │   ├── forgot_password.php
│   │   └── reset_password.php
│   │
│   ├── dashboard/
│   │   └── index.php          ← Stats cards, Chart.js charts, activity log
│   │
│   ├── leads/
│   │   ├── index.php          ← Lead list: filters (incl. custom fields), batch actions, export
│   │   ├── add.php            ← Add lead form (all custom fields auto-rendered)
│   │   ├── edit.php           ← Edit lead form
│   │   ├── view.php           ← Lead detail view + history
│   │   ├── delete.php         ← Single lead delete (admin)
│   │   ├── batch_action.php   ← Batch: status, assign, bulk field edit, delete
│   │   ├── export_selected.php← CSV export for selected lead IDs
│   │   └── bulk_upload.php    ← CSV drag-drop import with column mapping
│   │
│   ├── admin/
│   │   └── custom_fields.php  ← Custom field manager (ALL roles can add fields)
│   │
│   ├── users/
│   │   └── index.php          ← User management (admin only)
│   │
│   └── audit/
│       └── index.php          ← Audit log viewer (admin only)
│
├── api/
│   └── bin_lookup.php         ← BIN lookup API proxy (binlist.net)
│
├── assets/
│   ├── css/app.css            ← All styles: layout, badges, forms, dark mode
│   └── js/app.js              ← Theme toggle, sidebar, phone/name format, BIN lookup, ZIP fill
│
└── install/
    ├── install.php            ← Web installer (DELETE AFTER USE)
    ├── schema.sql             ← Full database schema
    └── migrate_v1_to_v2.sql  ← Upgrade script for existing v1 installs
```

---

## User Roles & Permissions

| Feature                     | Agent | Processor | Admin |
|-----------------------------|-------|-----------|-------|
| Add / edit own leads        | ✅    | ✅        | ✅    |
| View all leads              | ❌    | ✅        | ✅    |
| Edit any lead               | ❌    | ✅        | ✅    |
| Add custom fields           | ✅    | ✅        | ✅    |
| Edit own custom fields      | ✅    | ✅        | ✅    |
| Edit any custom field       | ❌    | ❌        | ✅    |
| Delete custom fields        | Own   | Own       | All   |
| Bulk upload CSV             | ❌    | ✅        | ✅    |
| Batch assign / status change| ✅    | ✅        | ✅    |
| Batch delete                | ❌    | ✅        | ✅    |
| Export CSV                  | ✅*   | ✅        | ✅    |
| User management             | ❌    | ❌        | ✅    |
| Audit log                   | ❌    | ❌        | ✅    |

*Agents export only their own leads.

---

## Custom Fields

All three roles can create custom fields. Here's how:

1. Go to **Custom Fields** in the sidebar
2. Click **Add Field**
3. Fill in:
   - **Label**: Display name (e.g. "Referral Source")
   - **Field Key**: Auto-generated unique identifier (e.g. `referral_source`)
   - **Field Type**: Text, Number, Date, Dropdown, Textarea, Checkbox
   - **Dropdown Options**: One option per line (only for Dropdown type)
   - **Required**: Forces agents to fill this field before saving
   - **Show in filter bar**: Adds the field to the leads filter/search bar
   - **Show as list column**: Adds the field as a column in the leads table
4. Click **Save Field**

The new field instantly appears on all lead add/edit forms — no code changes needed.

**Permissions:**
- Any role can create fields
- Users can edit/delete fields they created
- Admins can edit/delete any field

---

## Bulk Upload (CSV Import)

1. Go to **Bulk Upload** in the sidebar (Admin/Processor only)
2. Drag and drop a CSV file (or click to browse) — max 10MB
3. In the column mapping step, map each CSV column to a CRM field
   - The system auto-guesses matches based on column names
   - Unmapped columns are skipped
4. Click **Import Leads**
5. Review the import results (success count, failures)

**CSV Tips:**
- First row must be a header row
- Supported field names for auto-mapping: `first_name`, `last_name`, `email`, `phone`, `address`, `city`, `state`, `zip`, `annual_income`, `card_number_bin`, etc.
- Dates should be in YYYY-MM-DD format

---

## Lead Filtering & Search

The leads list supports filtering on:
- **Text search**: Name, email, phone, reference number, bank/issuer
- **Status**: New, In Review, Approved, Declined, Forwarded, On Hold
- **Agent** (non-agent roles)
- **BIN**: Partial match on card BIN
- **Date range**: Added from/to
- **Any custom field** marked as "searchable"

All filters combine (AND logic) and are bookmarkable via URL parameters.

---

## Batch Actions

Select leads using checkboxes, then choose a batch action:

| Action                    | Description                                  |
|---------------------------|----------------------------------------------|
| Forward to Processing     | Sets status to Forwarded                     |
| Mark [Status]             | Changes status for all selected              |
| Assign to Processor…      | Opens dialog to pick processor               |
| Set: [Custom Field]…      | Opens dialog to set a field value for all    |
| Export Selected as CSV    | Downloads selected leads as CSV              |
| Delete Selected           | Permanently deletes (admin/processor only)   |

All batch actions are logged in the Audit Trail.

---

## CSV Export

- **Export All (filtered)**: Click "Export CSV" button in the top-right of the Leads page. Exports all leads matching your current filters (up to 100,000).
- **Export Selected**: Select leads with checkboxes → Batch Action → Export Selected as CSV.
- Both exports include all standard fields + all custom field values.

---

## Performance Notes (100k+ Leads)

The schema is optimized for large datasets:
- Indexed columns: `status`, `agent_id`, `assigned_to`, `created_at`, `last_name/first_name`, `card_number_bin`
- Custom field searches use indexed `value_search` prefix column
- Query uses separate JOINs per custom field filter (avoids full scans)
- Pagination with configurable page size (25/50/100/200 rows)
- Export streams directly to download without loading all rows into memory

For very large databases (1M+ leads), consider:
- Adding `created_at` to composite indexes alongside `status` and `agent_id`
- Moving to a dedicated MySQL server
- Archiving old leads to a separate table

---

## Security Features

- **CSRF tokens** on every POST form
- **Session expiry** (configurable in `config.php`, default 1 hour)
- **Role-based access control** enforced server-side on every page
- **Password hashing** with bcrypt (cost 12)
- **Secure session** flags (httponly, SameSite=Lax, Secure on HTTPS)
- **Audit log** of every create/update/delete/login/export action
- **IP Whitelist** optional — set `ENABLE_IP_WHITELIST = true` in config.php, then add IPs via phpMyAdmin into the `ip_whitelist` table
- `.htaccess` blocks direct browser access to `includes/` and `config/`

---

## Config Reference (`config/config.php`)

```php
define('DB_HOST',    'localhost');       // MySQL host
define('DB_NAME',    'your_db');        // Database name
define('DB_USER',    'your_user');      // Database user
define('DB_PASS',    'your_pass');      // Database password
define('APP_NAME',   'Financial Leads CRM'); // Shown in UI
define('APP_URL',    '/crm');           // Path from domain root, no trailing slash
define('SESSION_LIFETIME',    3600);    // Session timeout in seconds
define('ENABLE_IP_WHITELIST', false);   // Set true to restrict access by IP
```

---

## Troubleshooting

| Problem | Solution |
|---------|----------|
| White page / PHP error | Check PHP error log in cPanel; ensure PHP 8.0+ |
| "CSRF validation failed" | Clear cookies and try again; check APP_URL is correct |
| Can't login after install | Verify DB credentials in `config/config.php` |
| BIN lookup not working | Server may block outbound HTTP; check cPanel firewall |
| ZIP autocomplete not working | Requires outbound HTTPS to `api.zippopotam.us` |
| Custom field not showing | Check it is set to Active in Custom Fields page |
| Can't see other agents' leads | Processor/Admin role required |
| Export downloads empty file | Check PHP `memory_limit` and `max_execution_time` |
