<?php
require_once __DIR__.'/../config/config.php';
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/auth.php';
require_once __DIR__.'/../includes/helpers.php';
session_start_secure();

header('Content-Type: application/json');

if (!is_logged_in()) { echo json_encode(['error'=>'Not authenticated']); exit; }

$bin = preg_replace('/\D/','', $_GET['bin'] ?? '');
if (strlen($bin) < 6) { echo json_encode([]); exit; }
$bin6 = substr($bin,0,6);

// Try free BIN lookup API
$ctx = stream_context_create(['http'=>[
    'timeout'       => 3,
    'ignore_errors' => true,
    'header'        => "Accept-Version: 3\r\nUser-Agent: CRM/1.0\r\n",
]]);
$raw = @file_get_contents("https://lookup.binlist.net/$bin6", false, $ctx);
$data = $raw ? json_decode($raw, true) : null;

if ($data && !isset($data['error'])) {
    echo json_encode([
        'brand'  => $data['scheme'] ?? '',
        'type'   => $data['type']   ?? '',
        'issuer' => $data['bank']['name'] ?? '',
        'country'=> $data['country']['name'] ?? '',
    ]);
} else {
    echo json_encode([]);
}
