<?php
function session_start_secure(): void {
    if (session_status() === PHP_SESSION_NONE) {
        ini_set('session.cookie_httponly', 1);
        ini_set('session.use_strict_mode', 1);
        if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') {
            ini_set('session.cookie_secure', 1);
        }
        session_set_cookie_params(['samesite' => 'Lax']);
        session_start();
    }
}

function is_logged_in(): bool { return !empty($_SESSION['user_id']); }

function current_user(): ?array { return $_SESSION['crm_user'] ?? null; }

function require_login(): void {
    if (!is_logged_in()) {
        header('Location: '.APP_URL.'/index.php?redir='.urlencode($_SERVER['REQUEST_URI']));
        exit;
    }
    if (defined('ENABLE_IP_WHITELIST') && ENABLE_IP_WHITELIST) {
        $ip = $_SERVER['REMOTE_ADDR'];
        $st = db()->prepare("SELECT id FROM ip_whitelist WHERE ip_address=? AND is_active=1");
        $st->execute([$ip]);
        if (!$st->fetch()) { session_destroy(); http_response_code(403); die('Access denied.'); }
    }
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > SESSION_LIFETIME)) {
        session_unset(); session_destroy();
        header('Location: '.APP_URL.'/index.php?timeout=1'); exit;
    }
    $_SESSION['last_activity'] = time();
}

function require_role(string ...$roles): void {
    require_login();
    if (!in_array(current_user()['role'] ?? '', $roles, true)) {
        http_response_code(403); die('<h2>Access Denied</h2>');
    }
}

function login_user(array $user): void {
    session_regenerate_id(true);
    $_SESSION['user_id']       = $user['id'];
    $_SESSION['crm_user']      = $user;
    $_SESSION['last_activity'] = time();
    db()->prepare("UPDATE users SET last_login=NOW() WHERE id=?")->execute([$user['id']]);
}

function logout_user(): void {
    audit('logout','user',$_SESSION['user_id'] ?? null);
    session_unset(); session_destroy();
}

function audit(string $action, ?string $entityType=null, ?int $entityId=null, ?string $details=null): void {
    try {
        $u = current_user();
        db()->prepare("INSERT INTO audit_log (user_id,username,action,entity_type,entity_id,details,ip_address) VALUES (?,?,?,?,?,?,?)")
           ->execute([$u['id'] ?? null,$u['username'] ?? null,$action,$entityType,$entityId,$details,$_SERVER['REMOTE_ADDR'] ?? null]);
    } catch (Exception $e) {}
}
