<?php
// includes/layout_header.php
$user = current_user();
$flash_s = get_flash('success');
$flash_e = get_flash('error');
$flash_i = get_flash('info');
$theme = $_COOKIE['crm_theme'] ?? 'light';
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="<?= $theme ?>">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= h($pageTitle??'CRM') ?> — <?= h(APP_NAME) ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <link rel="stylesheet" href="<?= APP_URL ?>/assets/css/app.css">
</head>
<body>

<div class="d-flex" id="crm-wrapper">
  <!-- Sidebar -->
  <nav id="sidebar" class="d-flex flex-column flex-shrink-0">
    <a href="<?= APP_URL ?>/modules/dashboard/index.php" class="sidebar-brand text-decoration-none d-flex align-items-center gap-2 px-3 py-3">
      <i class="bi bi-credit-card-2-front-fill fs-5 text-primary"></i>
      <span class="fw-bold sidebar-full-text"><?= h(APP_NAME) ?></span>
    </a>
    <hr class="my-0 opacity-10">
    <ul class="nav nav-pills flex-column gap-1 px-2 py-2 flex-grow-1">

      <li><a href="<?= APP_URL ?>/modules/dashboard/index.php" class="nav-link <?= str_contains($_SERVER['REQUEST_URI'],'dashboard')?'active':'' ?>">
        <i class="bi bi-speedometer2"></i><span class="sidebar-full-text ms-2">Dashboard</span></a></li>

      <li><a href="<?= APP_URL ?>/modules/leads/index.php" class="nav-link <?= (str_contains($_SERVER['REQUEST_URI'],'/leads/') && !str_contains($_SERVER['REQUEST_URI'],'add'))?'active':'' ?>">
        <i class="bi bi-people"></i><span class="sidebar-full-text ms-2">Leads</span></a></li>

      <li><a href="<?= APP_URL ?>/modules/leads/add.php" class="nav-link <?= str_contains($_SERVER['REQUEST_URI'],'leads/add')?'active':'' ?>">
        <i class="bi bi-person-plus"></i><span class="sidebar-full-text ms-2">Add New Lead</span></a></li>

      <?php if($user['role']==='agent'): ?>
      <li><a href="<?= APP_URL ?>/modules/leads/call_queue.php" class="nav-link <?= str_contains($_SERVER['REQUEST_URI'],'call_queue')?'active':'' ?>">
        <i class="bi bi-telephone-outbound"></i><span class="sidebar-full-text ms-2">Call Queue</span></a></li>
      <?php endif; ?>

      <?php if($user['role']==='admin'): ?>
      <li class="mt-2"><small class="sidebar-full-text text-muted px-2 text-uppercase" style="font-size:.65rem;letter-spacing:.08em">Admin</small></li>
      <li><a href="<?= APP_URL ?>/modules/leads/bulk_upload.php" class="nav-link <?= str_contains($_SERVER['REQUEST_URI'],'bulk')?'active':'' ?>">
        <i class="bi bi-cloud-upload"></i><span class="sidebar-full-text ms-2">Bulk Upload</span></a></li>
      <li><a href="<?= APP_URL ?>/modules/users/index.php" class="nav-link <?= str_contains($_SERVER['REQUEST_URI'],'/users/')?'active':'' ?>">
        <i class="bi bi-person-gear"></i><span class="sidebar-full-text ms-2">User Management</span></a></li>
      <li><a href="<?= APP_URL ?>/modules/audit/index.php" class="nav-link <?= str_contains($_SERVER['REQUEST_URI'],'audit')?'active':'' ?>">
        <i class="bi bi-journal-text"></i><span class="sidebar-full-text ms-2">Audit Log</span></a></li>
      <li><a href="<?= APP_URL ?>/modules/admin/updater.php" class="nav-link <?= str_contains($_SERVER['REQUEST_URI'],'updater')?'active':'' ?>">
        <i class="bi bi-arrow-repeat"></i><span class="sidebar-full-text ms-2">System Update</span></a></li>
      <?php endif; ?>

      <?php if($user['role']==='processor'): ?>
      <li><a href="<?= APP_URL ?>/modules/leads/index.php?status=forwarded" class="nav-link">
        <i class="bi bi-send"></i><span class="sidebar-full-text ms-2">Processing Queue</span></a></li>
      <?php endif; ?>

      <!-- All roles: custom fields -->
      <li class="mt-2"><small class="sidebar-full-text text-muted px-2 text-uppercase" style="font-size:.65rem;letter-spacing:.08em">Settings</small></li>
      <li><a href="<?= APP_URL ?>/modules/admin/custom_fields.php" class="nav-link <?= str_contains($_SERVER['REQUEST_URI'],'custom_fields')?'active':'' ?>">
        <i class="bi bi-sliders"></i><span class="sidebar-full-text ms-2">Custom Fields</span></a></li>

    </ul>
    <hr class="my-0 opacity-10">
    <!-- User strip -->
    <div class="px-3 py-2 d-flex align-items-center gap-2">
      <div class="avatar-circle"><?= strtoupper(substr($user['full_name']?:$user['username'],0,1)) ?></div>
      <div class="flex-grow-1 sidebar-full-text overflow-hidden">
        <div class="fw-semibold text-truncate small"><?= h($user['full_name']?:$user['username']) ?></div>
        <div class="text-muted text-capitalize" style="font-size:.7rem"><?= h($user['role']) ?></div>
      </div>
      <a href="<?= APP_URL ?>/modules/auth/logout.php" class="btn btn-sm btn-outline-secondary p-1 lh-1" title="Logout">
        <i class="bi bi-box-arrow-right"></i></a>
    </div>
  </nav>

  <!-- Main content -->
  <div id="page-content" class="flex-grow-1 d-flex flex-column overflow-hidden">

    <!-- Top bar -->
    <header class="topbar d-flex align-items-center px-4 gap-3">
      <button class="btn btn-sm btn-outline-secondary d-md-none" id="sidebarToggleMobile">
        <i class="bi bi-list fs-5"></i></button>
      <button class="btn btn-sm btn-outline-secondary d-none d-md-inline-flex" id="sidebarToggle" title="Toggle sidebar">
        <i class="bi bi-layout-sidebar"></i></button>
      <span class="fw-semibold ms-1"><?= h($pageTitle??'') ?></span>
      <div class="ms-auto d-flex align-items-center gap-2">
        <button class="btn btn-sm btn-outline-secondary" id="themeToggle" title="Toggle dark mode">
          <i class="bi bi-<?= $theme==='dark'?'sun':'moon' ?>"></i></button>
      </div>
    </header>

    <!-- Flash messages -->
    <div class="px-4 pt-2">
    <?php if($flash_s): ?>
      <div class="alert alert-success alert-dismissible fade show py-2" role="alert">
        <i class="bi bi-check-circle me-1"></i><?= h($flash_s) ?>
        <button type="button" class="btn-close py-2" data-bs-dismiss="alert"></button></div>
    <?php endif; ?>
    <?php if($flash_e): ?>
      <div class="alert alert-danger alert-dismissible fade show py-2" role="alert">
        <i class="bi bi-exclamation-triangle me-1"></i><?= h($flash_e) ?>
        <button type="button" class="btn-close py-2" data-bs-dismiss="alert"></button></div>
    <?php endif; ?>
    <?php if($flash_i): ?>
      <div class="alert alert-info alert-dismissible fade show py-2" role="alert">
        <i class="bi bi-info-circle me-1"></i><?= h($flash_i) ?>
        <button type="button" class="btn-close py-2" data-bs-dismiss="alert"></button></div>
    <?php endif; ?>
    </div>

    <div class="page-body px-4 py-3 flex-grow-1 overflow-auto">
