<?php
require_once __DIR__.'/config/config.php';
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/auth.php';
require_once __DIR__.'/includes/helpers.php';
session_start_secure();

if (is_logged_in()) { redirect(APP_URL.'/modules/dashboard/index.php'); }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    if ($username && $password) {
        $st = db()->prepare("SELECT * FROM users WHERE (username=? OR email=?) AND is_active=1 LIMIT 1");
        $st->execute([$username,$username]);
        $user = $st->fetch();
        if ($user && password_verify($password, $user['password_hash'])) {
            login_user($user);
            audit('login','user',$user['id'],'Login from '.$_SERVER['REMOTE_ADDR']);
            $redir = $_GET['redir'] ?? APP_URL.'/modules/dashboard/index.php';
            redirect($redir);
        }
    }
    $error = 'Invalid username or password.';
    audit('login_failed',null,null,'Attempt: '.$username);
}
$theme = $_COOKIE['crm_theme'] ?? 'light';
$timeout = !empty($_GET['timeout']);
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="<?= $theme ?>">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login — <?= h(APP_NAME) ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <link rel="stylesheet" href="<?= APP_URL ?>/assets/css/app.css">
</head>
<body class="login-page">
<div class="position-absolute top-0 end-0 p-3">
  <button class="btn btn-sm btn-outline-secondary" id="themeToggle">
    <i class="bi bi-<?= $theme==='dark'?'sun':'moon' ?>"></i></button>
</div>

<div class="login-card card shadow-sm p-4">
  <div class="text-center mb-4">
    <div class="login-logo mb-2"><i class="bi bi-credit-card-2-front-fill text-primary"></i></div>
    <h5 class="fw-bold mb-0"><?= h(APP_NAME) ?></h5>
    <p class="text-muted small mt-1">Secure Agent Portal</p>
  </div>

  <?php if($timeout): ?>
    <div class="alert alert-warning py-2 small"><i class="bi bi-clock me-1"></i>Your session expired. Please log in again.</div>
  <?php endif; ?>
  <?php if($error): ?>
    <div class="alert alert-danger py-2 small"><i class="bi bi-exclamation-triangle me-1"></i><?= h($error) ?></div>
  <?php endif; ?>

  <form method="post" autocomplete="on">
    <div class="mb-3">
      <label class="form-label">Username or Email</label>
      <div class="input-group">
        <span class="input-group-text"><i class="bi bi-person"></i></span>
        <input type="text" name="username" class="form-control" placeholder="Enter username" autofocus autocomplete="username" value="<?= h($_POST['username']??'') ?>">
      </div>
    </div>
    <div class="mb-4">
      <label class="form-label">Password</label>
      <div class="input-group">
        <span class="input-group-text"><i class="bi bi-lock"></i></span>
        <input type="password" name="password" class="form-control" placeholder="Enter password" autocomplete="current-password" id="pwField">
        <button class="btn btn-outline-secondary" type="button" id="pwToggle"><i class="bi bi-eye"></i></button>
      </div>
    </div>
    <button type="submit" class="btn btn-primary w-100 mb-3">
      <i class="bi bi-box-arrow-in-right me-1"></i>Login
    </button>
    <div class="text-center">
      <a href="<?= APP_URL ?>/modules/auth/forgot_password.php" class="small text-muted text-decoration-none">
        Forgot Password?</a>
    </div>
  </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Theme toggle
document.getElementById('themeToggle').addEventListener('click',()=>{
  const h=document.documentElement,d=h.getAttribute('data-bs-theme')==='dark',n=d?'light':'dark';
  h.setAttribute('data-bs-theme',n);
  document.cookie='crm_theme='+n+';path=/;max-age=31536000';
  document.querySelector('#themeToggle i').className='bi bi-'+(n==='dark'?'sun':'moon');
});
// Password show/hide
document.getElementById('pwToggle').addEventListener('click',()=>{
  const f=document.getElementById('pwField'),i=document.querySelector('#pwToggle i');
  f.type=f.type==='password'?'text':'password';
  i.className='bi bi-'+(f.type==='text'?'eye-slash':'eye');
});
</script>
</body>
</html>
