<?php
/**
 * CRM One-click Installer
 * Run: http://yourdomain.com/crm/install/install.php
 * DELETE this file after installation!
 */

$step   = $_POST['step'] ?? 'start';
$error  = '';
$success = '';

if ($step === 'install' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $host       = trim($_POST['db_host'] ?? 'localhost');
    $name       = trim($_POST['db_name'] ?? '');
    $user       = trim($_POST['db_user'] ?? '');
    $pass       = $_POST['db_pass'] ?? '';
    $adminUser  = trim($_POST['admin_user'] ?? 'admin');
    $adminEmail = trim($_POST['admin_email'] ?? '');
    $adminPass  = $_POST['admin_pass'] ?? '';
    $adminName  = trim($_POST['admin_name'] ?? 'Administrator');
    $appUrl     = rtrim(trim($_POST['app_url'] ?? '/crm'),'/');

    if (!$name || !$user || !$adminEmail || !$adminPass) {
        $error = 'Please fill in all required fields.';
    } elseif (strlen($adminPass) < 8) {
        $error = 'Admin password must be at least 8 characters.';
    } else {
        try {
            $pdo = new PDO("mysql:host=$host;charset=utf8mb4", $user, $pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $pdo->exec("USE `$name`");

            // Run schema
            $sql = file_get_contents(__DIR__ . '/schema.sql');
            foreach (explode(';', $sql) as $stmt) {
                $stmt = trim(preg_replace('/--.*$/m', '', $stmt));
                if ($stmt) { try { $pdo->exec($stmt); } catch(Exception $e) {} }
            }

            // Create admin user
            $hash = password_hash($adminPass, PASSWORD_BCRYPT, ['cost' => 12]);
            $st = $pdo->prepare("INSERT INTO users (username,email,password_hash,role,full_name,is_active) VALUES (?,?,?,'admin',?,1) ON DUPLICATE KEY UPDATE password_hash=VALUES(password_hash), email=VALUES(email)");
            $st->execute([$adminUser, $adminEmail, $hash, $adminName]);

            // Write config.php
            $configContent = <<<PHP
<?php
define('DB_HOST',    '$host');
define('DB_NAME',    '$name');
define('DB_USER',    '$user');
define('DB_PASS',    '$pass');
define('DB_CHARSET', 'utf8mb4');
define('APP_NAME',   'Financial Leads CRM');
define('APP_URL',    '$appUrl');
define('SESSION_LIFETIME',    3600);
define('ENABLE_IP_WHITELIST', false);
PHP;
            file_put_contents(dirname(__DIR__) . '/config/config.php', $configContent);
            $success = 'Installation complete!';

        } catch (Exception $e) {
            $error = 'Error: ' . htmlspecialchars($e->getMessage());
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Install — Financial Leads CRM</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <style>
    body{background:#f8f9fa;display:flex;align-items:center;justify-content:center;min-height:100vh;}
    .install-card{max-width:520px;width:100%;border-radius:14px;}
  </style>
</head>
<body>
<div class="install-card card shadow p-4">
  <div class="text-center mb-4">
    <i class="bi bi-credit-card-2-front-fill text-primary fs-1"></i>
    <h4 class="fw-bold mt-2">CRM Installer</h4>
    <p class="text-muted small">Financial Leads CRM</p>
  </div>

  <?php if ($success): ?>
    <div class="alert alert-success">
      <i class="bi bi-check-circle me-1"></i><strong>Installation complete!</strong><br>
      <a href="../index.php" class="alert-link">Login to your CRM →</a>
    </div>
    <div class="alert alert-warning small">
      <i class="bi bi-exclamation-triangle me-1"></i>
      <strong>Important:</strong> Delete the <code>install/</code> folder from your server now.
    </div>
  <?php else: ?>
    <?php if ($error): ?><div class="alert alert-danger small"><i class="bi bi-x-circle me-1"></i><?= $error ?></div><?php endif; ?>
    <form method="post">
      <input type="hidden" name="step" value="install">
      <p class="form-section-title mb-3" style="font-size:.72rem;text-transform:uppercase;letter-spacing:.08em;color:#6c757d;border-bottom:1px solid #dee2e6;padding-bottom:.4rem;font-weight:600">Database</p>
      <div class="row g-3 mb-3">
        <div class="col-5"><label class="form-label">DB Host</label><input name="db_host" class="form-control" value="localhost"></div>
        <div class="col-7"><label class="form-label">Database Name *</label><input name="db_name" class="form-control" required></div>
        <div class="col-6"><label class="form-label">DB Username *</label><input name="db_user" class="form-control" required></div>
        <div class="col-6"><label class="form-label">DB Password</label><input type="password" name="db_pass" class="form-control"></div>
        <div class="col-12"><label class="form-label">App URL Path</label>
          <input name="app_url" class="form-control" value="/crm" placeholder="/crm">
          <div class="form-text">Path from domain root, e.g. /crm or /public_html/crm</div>
        </div>
      </div>
      <p class="form-section-title mb-3" style="font-size:.72rem;text-transform:uppercase;letter-spacing:.08em;color:#6c757d;border-bottom:1px solid #dee2e6;padding-bottom:.4rem;font-weight:600">Admin Account</p>
      <div class="row g-3 mb-4">
        <div class="col-6"><label class="form-label">Full Name</label><input name="admin_name" class="form-control" value="Administrator"></div>
        <div class="col-6"><label class="form-label">Username</label><input name="admin_user" class="form-control" value="admin"></div>
        <div class="col-12"><label class="form-label">Email *</label><input type="email" name="admin_email" class="form-control" required></div>
        <div class="col-12"><label class="form-label">Password * <span class="text-muted small">(min 8 chars)</span></label>
          <input type="password" name="admin_pass" class="form-control" minlength="8" required></div>
      </div>
      <button type="submit" class="btn btn-primary w-100">
        <i class="bi bi-lightning-charge me-1"></i>Install CRM</button>
    </form>
  <?php endif; ?>
</div>
</body>
</html>
