-- ============================================================
--  CRM Migration: v1 → v2
--  Run this SQL in phpMyAdmin if upgrading an existing install.
--  Safe to run multiple times (uses IF NOT EXISTS checks).
-- ============================================================

-- Add new columns to custom_fields
ALTER TABLE `custom_fields`
  ADD COLUMN IF NOT EXISTS `show_in_list` TINYINT(1) NOT NULL DEFAULT 0 AFTER `is_required`,
  ADD COLUMN IF NOT EXISTS `searchable`   TINYINT(1) NOT NULL DEFAULT 1 AFTER `show_in_list`,
  ADD COLUMN IF NOT EXISTS `created_by`   INT UNSIGNED DEFAULT NULL AFTER `searchable`;

-- Add value_search to lead_custom_values for fast searching
-- (Only works on MySQL 5.7.6+/MariaDB 5.2+ with generated columns)
-- If this fails, the system still works — just without the generated index
ALTER TABLE `lead_custom_values`
  ADD COLUMN IF NOT EXISTS `value_search` VARCHAR(500)
    GENERATED ALWAYS AS (LEFT(value, 500)) STORED COMMENT 'indexed prefix for search',
  ADD KEY IF NOT EXISTS `idx_search` (`custom_field_id`, `value_search`);

-- Add password_resets table if missing
CREATE TABLE IF NOT EXISTS `password_resets` (
  `id`         INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id`    INT UNSIGNED NOT NULL,
  `token`      VARCHAR(64)  NOT NULL,
  `expires_at` DATETIME     NOT NULL,
  `used`       TINYINT(1)   NOT NULL DEFAULT 0,
  `created_at` DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add date_from filter index on leads
ALTER TABLE `leads` ADD KEY IF NOT EXISTS `idx_created_date` (`created_at`);

-- ── v2.0 new tables ────────────────────────────────────────
CREATE TABLE IF NOT EXISTS `import_jobs` (
  `id`           INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id`      INT UNSIGNED NOT NULL,
  `filename`     VARCHAR(255) NOT NULL,
  `file_path`    VARCHAR(500) NOT NULL,
  `delimiter`    VARCHAR(5)   NOT NULL DEFAULT ',',
  `mapping`      TEXT                  DEFAULT NULL,
  `assign_to`    INT UNSIGNED          DEFAULT NULL,
  `total_rows`   INT UNSIGNED NOT NULL DEFAULT 0,
  `processed`    INT UNSIGNED NOT NULL DEFAULT 0,
  `imported`     INT UNSIGNED NOT NULL DEFAULT 0,
  `failed`       INT UNSIGNED NOT NULL DEFAULT 0,
  `status`       ENUM('pending','running','done','error') NOT NULL DEFAULT 'pending',
  `error_log`    TEXT                  DEFAULT NULL,
  `created_at`   DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `finished_at`  DATETIME              DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `call_log` (
  `id`         INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `lead_id`    INT UNSIGNED NOT NULL,
  `agent_id`   INT UNSIGNED NOT NULL,
  `outcome`    ENUM('no_answer','voicemail','callback','picked_up','wrong_number','do_not_call') NOT NULL,
  `notes`      TEXT                  DEFAULT NULL,
  `created_at` DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_lead` (`lead_id`),
  KEY `idx_agent` (`agent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `system_updates` (
  `id`          INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `version`     VARCHAR(20)  NOT NULL,
  `applied_by`  INT UNSIGNED          DEFAULT NULL,
  `notes`       TEXT                  DEFAULT NULL,
  `status`      ENUM('success','failed') NOT NULL DEFAULT 'success',
  `created_at`  DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `applied_migrations` (
  `filename`   VARCHAR(255) NOT NULL,
  `applied_at` DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`filename`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
