<?php
require_once __DIR__.'/../../config/config.php';
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/auth.php';
require_once __DIR__.'/../../includes/helpers.php';
session_start_secure();
require_role('admin');

$db = db();

// Filters
$userF   = (int)($_GET['user_id']??0);
$action  = trim($_GET['action']??'');
$dateF   = trim($_GET['date']??'');
$page    = max(1,(int)($_GET['page']??1));
$perPage = 50;

$where  = ['1'];
$params = [];
if ($userF)  { $where[]='al.user_id=?';              $params[]=$userF; }
if ($action) { $where[]='al.action LIKE ?';           $params[]='%'.$action.'%'; }
if ($dateF)  { $where[]='DATE(al.created_at)=?';      $params[]=$dateF; }
$whereStr = implode(' AND ',$where);

$total = (int)$db->prepare("SELECT COUNT(*) FROM audit_log al WHERE $whereStr")->execute($params) ? $db->prepare("SELECT COUNT(*) FROM audit_log al WHERE $whereStr")->execute($params)||1 : 0;
$tSt = $db->prepare("SELECT COUNT(*) FROM audit_log al WHERE $whereStr");
$tSt->execute($params); $total=(int)$tSt->fetchColumn();

$pages  = max(1,(int)ceil($total/$perPage));
$offset = ($page-1)*$perPage;

$st = $db->prepare("SELECT al.*, u.full_name FROM audit_log al LEFT JOIN users u ON u.id=al.user_id
    WHERE $whereStr ORDER BY al.created_at DESC LIMIT $perPage OFFSET $offset");
$st->execute($params);
$logs = $st->fetchAll();

$users = $db->query("SELECT id,username,full_name FROM users ORDER BY full_name")->fetchAll();

$pageTitle = 'Audit Log';
include __DIR__.'/../../includes/layout_header.php';
?>

<div class="page-header">
  <h1><i class="bi bi-journal-text me-2 text-primary fs-4"></i>Audit Log</h1>
  <p class="text-muted small mb-0"><?= number_format($total) ?> log entries</p>
</div>

<!-- Filters -->
<form method="get" class="filter-bar mb-4">
  <div class="row g-2 align-items-end">
    <div class="col-md-3">
      <label class="form-label mb-1">User</label>
      <select name="user_id" class="form-select form-select-sm">
        <option value="">All Users</option>
        <?php foreach($users as $u): ?>
          <option value="<?= $u['id'] ?>" <?= $userF==$u['id']?'selected':'' ?>>
            <?= h($u['full_name']?:$u['username']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label mb-1">Action</label>
      <input type="text" name="action" class="form-control form-control-sm" placeholder="e.g. login, lead_created" value="<?= h($action) ?>">
    </div>
    <div class="col-md-2">
      <label class="form-label mb-1">Date</label>
      <input type="date" name="date" class="form-control form-control-sm" value="<?= h($dateF) ?>">
    </div>
    <div class="col-auto">
      <button type="submit" class="btn btn-primary btn-sm"><i class="bi bi-funnel me-1"></i>Filter</button>
      <a href="<?= APP_URL ?>/modules/audit/index.php" class="btn btn-outline-secondary btn-sm ms-1">Clear</a>
    </div>
  </div>
</form>

<div class="card">
  <div class="table-responsive">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>Timestamp</th>
          <th>User</th>
          <th>Action</th>
          <th>Entity</th>
          <th>Details</th>
          <th>IP</th>
        </tr>
      </thead>
      <tbody>
        <?php if($logs): foreach($logs as $l): ?>
        <tr>
          <td class="mono text-muted" style="font-size:.78rem"><?= h(date('Y-m-d H:i:s',strtotime($l['created_at']))) ?></td>
          <td class="small"><?= h($l['full_name']?:$l['username']?:'System') ?></td>
          <td><span class="tag"><?= h($l['action']) ?></span></td>
          <td class="small text-muted">
            <?php if($l['entity_type']&&$l['entity_id']): ?>
              <span class="mono"><?= h($l['entity_type']) ?>:<?= h($l['entity_id']) ?></span>
              <?php if($l['entity_type']==='lead'): ?>
                <a href="<?= APP_URL ?>/modules/leads/view.php?id=<?= $l['entity_id'] ?>" class="ms-1"><i class="bi bi-box-arrow-up-right" style="font-size:.7rem"></i></a>
              <?php endif; ?>
            <?php else: ?>—<?php endif; ?>
          </td>
          <td class="text-muted small" style="max-width:250px"><?= h(mb_strimwidth($l['details']??'',0,100,'…')) ?></td>
          <td class="mono text-muted" style="font-size:.75rem"><?= h($l['ip_address']?:'—') ?></td>
        </tr>
        <?php endforeach; else: ?>
        <tr><td colspan="6" class="text-center text-muted py-5">
          <i class="bi bi-journal fs-3 d-block mb-2 opacity-25"></i>No log entries found.
        </td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <?php if($pages>1): ?>
  <div class="card-footer d-flex align-items-center justify-content-between py-2">
    <small class="text-muted">Page <?= $page ?> of <?= $pages ?></small>
    <nav><ul class="pagination pagination-sm mb-0 gap-1">
      <?php
      $qp=$_GET; unset($qp['page']); $base='?'.http_build_query($qp).'&page=';
      if($page>1): ?><li class="page-item"><a class="page-link" href="<?= $base.($page-1) ?>">‹</a></li><?php endif; ?>
      <?php for($i=max(1,$page-2);$i<=min($pages,$page+2);$i++): ?>
        <li class="page-item <?= $i===$page?'active':'' ?>"><a class="page-link" href="<?= $base.$i ?>"><?= $i ?></a></li>
      <?php endfor; ?>
      <?php if($page<$pages): ?><li class="page-item"><a class="page-link" href="<?= $base.($page+1) ?>">›</a></li><?php endif; ?>
    </ul></nav>
  </div>
  <?php endif; ?>
</div>

<?php include __DIR__.'/../../includes/layout_footer.php'; ?>
