<?php
require_once __DIR__.'/../../config/config.php';
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/auth.php';
require_once __DIR__.'/../../includes/helpers.php';
session_start_secure();

$msg = ''; $error = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $email = trim($_POST['email']??'');
    $st = db()->prepare("SELECT id,username FROM users WHERE email=? AND is_active=1 LIMIT 1");
    $st->execute([$email]);
    $user = $st->fetch();
    if ($user) {
        $token = bin2hex(random_bytes(32));
        $exp   = date('Y-m-d H:i:s', time()+3600);
        db()->prepare("INSERT INTO password_resets (user_id,token,expires_at) VALUES (?,?,?)")->execute([$user['id'],$token,$exp]);
        // In production: send email with reset link
        $resetLink = APP_URL.'/modules/auth/reset_password.php?token='.$token;
        $msg = 'If that email exists, a reset link has been generated. (Dev mode: <a href="'.h($resetLink).'" class="alert-link">Click here</a>)';
    } else {
        $msg = 'If that email exists, a reset link has been sent.';
    }
}
$theme = $_COOKIE['crm_theme'] ?? 'light';
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="<?= $theme ?>">
<head>
  <meta charset="UTF-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Forgot Password — <?= h(APP_NAME) ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <link rel="stylesheet" href="<?= APP_URL ?>/assets/css/app.css">
</head>
<body class="login-page">
<div class="login-card card shadow-sm p-4">
  <div class="text-center mb-4">
    <div class="login-logo mb-2"><i class="bi bi-credit-card-2-front-fill text-primary"></i></div>
    <h5 class="fw-bold mb-0">Reset Password</h5>
    <p class="text-muted small mt-1"><?= h(APP_NAME) ?></p>
  </div>
  <?php if($msg): ?><div class="alert alert-success small"><?= $msg ?></div><?php endif; ?>
  <?php if($error): ?><div class="alert alert-danger small"><?= h($error) ?></div><?php endif; ?>
  <form method="post">
    <div class="mb-3">
      <label class="form-label">Email Address</label>
      <input type="email" name="email" class="form-control" placeholder="your@email.com" required autofocus>
    </div>
    <button type="submit" class="btn btn-primary w-100 mb-3">Send Reset Link</button>
    <div class="text-center"><a href="<?= APP_URL ?>/index.php" class="small text-muted text-decoration-none">← Back to Login</a></div>
  </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
