<?php
require_once __DIR__.'/../../config/config.php';
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/auth.php';
require_once __DIR__.'/../../includes/helpers.php';
session_start_secure();

$token = $_GET['token'] ?? $_POST['token'] ?? '';
$error = ''; $done = false;

$st = db()->prepare("SELECT pr.*,u.username FROM password_resets pr JOIN users u ON u.id=pr.user_id WHERE pr.token=? AND pr.used=0 AND pr.expires_at > NOW() LIMIT 1");
$st->execute([$token]);
$reset = $st->fetch();

if (!$reset) { $error = 'Invalid or expired token.'; }

if ($_SERVER['REQUEST_METHOD']==='POST' && $reset) {
    $p1 = $_POST['password']??''; $p2 = $_POST['password2']??'';
    if (strlen($p1)<8) { $error='Password must be at least 8 characters.'; }
    elseif ($p1!==$p2) { $error='Passwords do not match.'; }
    else {
        $hash = password_hash($p1, PASSWORD_BCRYPT, ['cost'=>12]);
        db()->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([$hash,$reset['user_id']]);
        db()->prepare("UPDATE password_resets SET used=1 WHERE id=?")->execute([$reset['id']]);
        audit('password_reset','user',$reset['user_id']);
        $done = true;
    }
}
$theme = $_COOKIE['crm_theme'] ?? 'light';
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="<?= $theme ?>">
<head>
  <meta charset="UTF-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Reset Password — <?= h(APP_NAME) ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <link rel="stylesheet" href="<?= APP_URL ?>/assets/css/app.css">
</head>
<body class="login-page">
<div class="login-card card shadow-sm p-4">
  <div class="text-center mb-4">
    <div class="login-logo mb-2"><i class="bi bi-credit-card-2-front-fill text-primary"></i></div>
    <h5 class="fw-bold mb-0">Set New Password</h5>
  </div>
  <?php if($done): ?>
    <div class="alert alert-success">Password updated! <a href="<?= APP_URL ?>/index.php" class="alert-link">Login now</a></div>
  <?php elseif($error && !$reset): ?>
    <div class="alert alert-danger"><?= h($error) ?></div>
    <a href="<?= APP_URL ?>/modules/auth/forgot_password.php" class="btn btn-outline-secondary w-100">Request New Link</a>
  <?php else: ?>
    <?php if($error): ?><div class="alert alert-danger small"><?= h($error) ?></div><?php endif; ?>
    <form method="post">
      <input type="hidden" name="token" value="<?= h($token) ?>">
      <div class="mb-3"><label class="form-label">New Password</label>
        <input type="password" name="password" class="form-control" minlength="8" required></div>
      <div class="mb-4"><label class="form-label">Confirm Password</label>
        <input type="password" name="password2" class="form-control" required></div>
      <button type="submit" class="btn btn-primary w-100">Update Password</button>
    </form>
  <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
