<?php
require_once __DIR__.'/../../config/config.php';
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/auth.php';
require_once __DIR__.'/../../includes/helpers.php';
session_start_secure();
require_login();

$user = current_user();
$db   = db();

// Stats
$today     = date('Y-m-d');
$weekStart = date('Y-m-d', strtotime('monday this week'));

$agentWhere = $user['role']==='agent' ? " AND agent_id={$user['id']}" : '';

$leadsToday = $db->query("SELECT COUNT(*) FROM leads WHERE DATE(created_at)='$today'$agentWhere")->fetchColumn();
$leadsWeek  = $db->query("SELECT COUNT(*) FROM leads WHERE created_at>='$weekStart'$agentWhere")->fetchColumn();
$leadsTotal = $db->query("SELECT COUNT(*) FROM leads WHERE 1$agentWhere")->fetchColumn();
$forwarded  = $db->query("SELECT COUNT(*) FROM leads WHERE status='forwarded'$agentWhere")->fetchColumn();
$procRate   = $leadsTotal > 0 ? round($forwarded/$leadsTotal*100) : 0;

// Status breakdown for chart
$statusRows = $db->query("SELECT status, COUNT(*) as cnt FROM leads WHERE 1$agentWhere GROUP BY status")->fetchAll();
$chartData  = [];
foreach ($statusRows as $r) $chartData[$r['status']] = (int)$r['cnt'];

// Last 14 days trend
$trendRows = $db->query("SELECT DATE(created_at) as d, COUNT(*) as cnt FROM leads WHERE created_at >= DATE_SUB(NOW(),INTERVAL 14 DAY)$agentWhere GROUP BY DATE(created_at) ORDER BY d")->fetchAll();
$trendLabels = $trendVals = [];
foreach ($trendRows as $r) { $trendLabels[] = date('M j',strtotime($r['d'])); $trendVals[] = (int)$r['cnt']; }

// Recent activity
$activity = $db->query("SELECT al.*, u.full_name FROM audit_log al LEFT JOIN users u ON u.id=al.user_id ORDER BY al.created_at DESC LIMIT 15")->fetchAll();

$pageTitle = 'Dashboard';
include __DIR__.'/../../includes/layout_header.php';
?>

<div class="page-header d-flex align-items-center justify-content-between">
  <div>
    <h1>Dashboard</h1>
    <p class="text-muted mb-0 small">Welcome back, <?= h($user['full_name']?:$user['username']) ?> &middot; <?= date('l, F j, Y') ?></p>
  </div>
  <a href="<?= APP_URL ?>/modules/leads/add.php" class="btn btn-primary">
    <i class="bi bi-person-plus me-1"></i>Add Lead</a>
</div>

<!-- Stat Cards -->
<div class="row g-3 mb-4">
  <div class="col-6 col-md-3">
    <div class="stat-card card bg-primary text-white">
      <div class="stat-value"><?= number_format($leadsToday) ?></div>
      <div class="stat-label">Leads Today</div>
      <i class="bi bi-person-plus stat-icon text-white"></i>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="stat-card card bg-success text-white">
      <div class="stat-value"><?= number_format($leadsWeek) ?></div>
      <div class="stat-label">This Week</div>
      <i class="bi bi-calendar-week stat-icon text-white"></i>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="stat-card card bg-warning text-dark">
      <div class="stat-value"><?= number_format($leadsTotal) ?></div>
      <div class="stat-label">Total Leads</div>
      <i class="bi bi-people stat-icon"></i>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="stat-card card bg-info text-dark">
      <div class="stat-value"><?= $procRate ?>%</div>
      <div class="stat-label">Processing Rate</div>
      <i class="bi bi-graph-up stat-icon"></i>
    </div>
  </div>
</div>

<!-- Charts Row -->
<div class="row g-3 mb-4">
  <div class="col-md-8">
    <div class="card h-100">
      <div class="card-header d-flex align-items-center justify-content-between">
        <span><i class="bi bi-graph-up-arrow me-2 text-primary"></i>Leads — Last 14 Days</span>
      </div>
      <div class="card-body">
        <canvas id="trendChart" height="80"></canvas>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card h-100">
      <div class="card-header"><i class="bi bi-pie-chart me-2 text-primary"></i>By Status</div>
      <div class="card-body d-flex align-items-center justify-content-center">
        <canvas id="statusChart" height="180"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Recent Activity -->
<div class="card">
  <div class="card-header"><i class="bi bi-clock-history me-2 text-primary"></i>Recent Activity</div>
  <div class="table-responsive">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>Time</th>
          <th>User</th>
          <th>Action</th>
          <th>Details</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($activity as $a): ?>
        <tr>
          <td class="text-muted small mono"><?= h(date('M j H:i', strtotime($a['created_at']))) ?></td>
          <td><?= h($a['full_name'] ?: $a['username'] ?: 'System') ?></td>
          <td><span class="tag"><?= h($a['action']) ?></span></td>
          <td class="text-muted small"><?= h(mb_strimwidth($a['details']??'',0,80,'…')) ?></td>
        </tr>
        <?php endforeach; ?>
        <?php if(!$activity): ?>
          <tr><td colspan="4" class="text-center text-muted py-4">No activity yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
const isDark = document.documentElement.getAttribute('data-bs-theme')==='dark';
const gridColor = isDark ? 'rgba(255,255,255,0.08)' : 'rgba(0,0,0,0.06)';
const textColor = isDark ? '#adb5bd' : '#6c757d';

// Trend chart
new Chart(document.getElementById('trendChart'), {
  type: 'bar',
  data: {
    labels: <?= json_encode($trendLabels) ?>,
    datasets: [{
      label: 'Leads',
      data: <?= json_encode($trendVals) ?>,
      backgroundColor: 'rgba(13,110,253,0.75)',
      borderRadius: 6,
    }]
  },
  options: {
    responsive:true, maintainAspectRatio:true,
    plugins:{ legend:{display:false} },
    scales:{
      y:{ beginAtZero:true, grid:{color:gridColor}, ticks:{color:textColor,stepSize:1} },
      x:{ grid:{display:false}, ticks:{color:textColor} }
    }
  }
});

// Status doughnut
const statusData = <?= json_encode($chartData) ?>;
const labels = Object.keys(statusData).map(s=>s.replace('_',' '));
const values = Object.values(statusData);
const colors = { new:'#198754',in_review:'#fd7e14',approved:'#0d6efd',declined:'#dc3545',forwarded:'#0dcaf0',on_hold:'#6c757d' };
const bgColors = Object.keys(statusData).map(s=>colors[s]||'#adb5bd');

new Chart(document.getElementById('statusChart'), {
  type: 'doughnut',
  data: { labels, datasets:[{ data:values, backgroundColor:bgColors, borderWidth:2, borderColor: isDark?'#212529':'#fff' }] },
  options: {
    responsive:true, maintainAspectRatio:false,
    plugins:{ legend:{ position:'bottom', labels:{ color:textColor, font:{size:11}, boxWidth:12 } } },
    cutout:'65%'
  }
});
</script>

<?php include __DIR__.'/../../includes/layout_footer.php'; ?>
