<?php
require_once __DIR__.'/../../config/config.php';
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/auth.php';
require_once __DIR__.'/../../includes/helpers.php';
session_start_secure();
require_login();
csrf_check();

$user = current_user();
$db   = db();

$action  = $_POST['action'] ?? '';
$idsRaw  = $_POST['ids']    ?? '';
$ids     = array_filter(array_map('intval', explode(',', $idsRaw)));
$redir   = $_POST['redirect_url'] ?? APP_URL.'/modules/leads/index.php';

// Sanitise redirect
if (!str_starts_with($redir, '/') && !str_starts_with($redir, APP_URL)) {
    $redir = APP_URL.'/modules/leads/index.php';
}

if (!$ids) {
    flash('error', 'No leads selected.');
    redirect($redir);
}

$in = implode(',', $ids);
$n  = count($ids);

// ── Status changes (all roles) ─────────────────────────────
$statusMap = [
    'forward'          => 'forwarded',
    'status_new'       => 'new',
    'status_in_review' => 'in_review',
    'status_approved'  => 'approved',
    'status_declined'  => 'declined',
    'status_on_hold'   => 'on_hold',
];

if (isset($statusMap[$action])) {
    $newStatus = $statusMap[$action];
    $fwdSql = ($newStatus === 'forwarded') ? ',forwarded_at=NOW()' : '';
    $db->query("UPDATE leads SET status='$newStatus'$fwdSql WHERE id IN ($in)");
    audit('batch_status_'.$newStatus, 'lead', null, "IDs: $in ($n leads)");
    flash('success', "$n lead(s) status set to ".ucfirst(str_replace('_',' ',$newStatus)).'.');
    redirect($redir);
}

// ── Assign to processor ────────────────────────────────────
if ($action === 'assign') {
    $assignTo = (int)($_POST['assign_to'] ?? 0) ?: null;
    $db->prepare("UPDATE leads SET assigned_to=? WHERE id IN ($in)")->execute([$assignTo]);
    $label = $assignTo ? 'user #'.$assignTo : 'unassigned';
    audit('batch_assign', 'lead', null, "IDs: $in → $label");
    flash('success', "$n lead(s) reassigned.");
    redirect($redir);
}

// ── Bulk custom field edit ─────────────────────────────────
if ($action === 'bulk_field_'.(string)($_POST['bulk_field_key'] ?? '') || str_starts_with($action, 'bulk_field_')) {
    $key = preg_replace('/[^a-z0-9_]/','', $_POST['bulk_field_key'] ?? str_replace('bulk_field_','',$action));
    $val = $_POST['bulk_field_value'] ?? '';

    $st = $db->prepare("SELECT id FROM custom_fields WHERE field_key=? AND is_active=1 LIMIT 1");
    $st->execute([$key]);
    $cf = $st->fetch();
    if (!$cf) { flash('error','Custom field not found.'); redirect($redir); }

    foreach ($ids as $lid) {
        $db->prepare("INSERT INTO lead_custom_values (lead_id,custom_field_id,value) VALUES (?,?,?)
            ON DUPLICATE KEY UPDATE value=VALUES(value)")
           ->execute([$lid, $cf['id'], $val]);
    }
    audit('batch_field_edit','lead',null,"Field: $key='$val' on IDs: $in");
    flash('success',"$n lead(s) updated: $key set.");
    redirect($redir);
}

// ── Delete (admin/processor only) ─────────────────────────
if ($action === 'delete') {
    if (!in_array($user['role'], ['admin','processor'])) {
        flash('error','Permission denied.'); redirect($redir);
    }
    $db->query("DELETE FROM leads WHERE id IN ($in)");
    audit('batch_delete','lead',null,"Deleted IDs: $in ($n leads)");
    flash('success',"$n lead(s) deleted.");
    redirect($redir);
}

flash('error', 'Unknown action: '.h($action));
redirect($redir);
