<?php
require_once __DIR__.'/../../config/config.php';
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/auth.php';
require_once __DIR__.'/../../includes/helpers.php';
session_start_secure();
require_login();

$user = current_user();
$id   = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
if (!$id) { flash('error','Invalid lead.'); redirect(APP_URL.'/modules/leads/index.php'); }

$st = db()->prepare("SELECT * FROM leads WHERE id=?");
$st->execute([$id]);
$lead = $st->fetch();
if (!$lead) { flash('error','Lead not found.'); redirect(APP_URL.'/modules/leads/index.php'); }

// Agents can only edit their own leads
if ($user['role']==='agent' && $lead['agent_id']!=$user['id']) {
    http_response_code(403); die('Access denied.');
}

$customFields = get_custom_fields();
$customVals   = get_lead_custom_values($id);
// Merge custom vals into lead array for form rendering
foreach($customVals as $k=>$v) $lead['cf_'.$k]=$v;

$errors = [];

if ($_SERVER['REQUEST_METHOD']==='POST') {
    csrf_check();
    $old_status = $lead['status'];

    $lead = array_merge($lead, [
        'first_name'         => trim($_POST['first_name']??''),
        'last_name'          => trim($_POST['last_name']??''),
        'email'              => trim($_POST['email']??''),
        'phone'              => preg_replace('/\D/','',trim($_POST['phone']??'')),
        'dob'                => trim($_POST['dob']??''),
        'ssn_last4'          => preg_replace('/\D/','',trim($_POST['ssn_last4']??'')),
        'address'            => trim($_POST['address']??''),
        'city'               => trim($_POST['city']??''),
        'state'              => trim($_POST['state']??''),
        'zip'                => trim($_POST['zip']??''),
        'annual_income'      => trim($_POST['annual_income']??''),
        'employment_status'  => trim($_POST['employment_status']??''),
        'credit_score_range' => trim($_POST['credit_score_range']??''),
        'requested_limit'    => trim($_POST['requested_limit']??''),
        'card_type'          => trim($_POST['card_type']??''),
        'card_number_bin'    => preg_replace('/\D/','',trim($_POST['card_number_bin']??'')),
        'card_brand'         => trim($_POST['card_brand']??''),
        'card_issuer'        => trim($_POST['card_issuer']??''),
        'card_type_detail'   => trim($_POST['card_type_detail']??''),
        'status'             => trim($_POST['status']??'new'),
        'assigned_to'        => trim($_POST['assigned_to']??''),
        'notes'              => trim($_POST['notes']??''),
    ]);

    if (!$lead['first_name']) $errors[]='First name is required.';
    if (!$lead['last_name'])  $errors[]='Last name is required.';
    if ($lead['email'] && !filter_var($lead['email'],FILTER_VALIDATE_EMAIL)) $errors[]='Invalid email.';

    if (!$errors) {
        $forwardedAt = $lead['forwarded_at'];
        if ($lead['status']==='forwarded' && $old_status!=='forwarded') $forwardedAt=date('Y-m-d H:i:s');

        db()->prepare("UPDATE leads SET
            first_name=?,last_name=?,email=?,phone=?,dob=?,ssn_last4=?,
            address=?,city=?,state=?,zip=?,annual_income=?,employment_status=?,
            credit_score_range=?,requested_limit=?,card_type=?,card_number_bin=?,
            card_brand=?,card_issuer=?,card_type_detail=?,status=?,assigned_to=?,
            notes=?,forwarded_at=? WHERE id=?
        ")->execute([
            $lead['first_name'],$lead['last_name'],$lead['email']?:null,$lead['phone']?:null,
            $lead['dob']?:null,$lead['ssn_last4']?:null,$lead['address']?:null,
            $lead['city']?:null,$lead['state']?:null,$lead['zip']?:null,
            $lead['annual_income']?:null,$lead['employment_status']?:null,
            $lead['credit_score_range']?:null,$lead['requested_limit']?:null,
            $lead['card_type']?:null,$lead['card_number_bin']?:null,
            $lead['card_brand']?:null,$lead['card_issuer']?:null,$lead['card_type_detail']?:null,
            $lead['status'],$lead['assigned_to']?:null,
            $lead['notes']?:null,$forwardedAt,$id
        ]);
        save_custom_values($id,$customFields,$_POST);
        audit('lead_updated','lead',$id,"Status: {$old_status}→{$lead['status']}");
        flash('success','Lead updated successfully.');
        redirect(APP_URL.'/modules/leads/view.php?id='.$id);
    }
}

$processors = db()->query("SELECT id,full_name,username FROM users WHERE role IN ('processor','admin') AND is_active=1 ORDER BY full_name")->fetchAll();
$fromQueue = !empty($_GET['from']) && $_GET['from']==='queue';

// Fetch call log for this lead
$callHistory = $db->prepare("SELECT cl.*,u.full_name as agent_name FROM call_log cl LEFT JOIN users u ON u.id=cl.agent_id WHERE cl.lead_id=? ORDER BY cl.created_at DESC LIMIT 10");
$callHistory->execute([$id]);
$callHistory = $callHistory->fetchAll();

$pageTitle = 'Edit Lead: '.h($lead['first_name'].' '.$lead['last_name']);
include __DIR__.'/../../includes/layout_header.php';
?>

<div class="page-header d-flex align-items-center justify-content-between">
  <div>
    <div class="mb-1">
      <?php if($fromQueue): ?>
      <a href="<?= APP_URL ?>/modules/leads/call_queue.php" class="text-muted text-decoration-none small">
        <i class="bi bi-arrow-left"></i> Back to Call Queue</a>
      <?php else: ?>
      <a href="<?= APP_URL ?>/modules/leads/view.php?id=<?= $id ?>" class="text-muted text-decoration-none small">
        <i class="bi bi-arrow-left"></i> Back to Lead</a>
      <?php endif; ?>
    </div>
    <h1><i class="bi bi-pencil me-2 text-primary fs-4"></i>
      <?= $fromQueue ? 'Customer Picked Up — Fill In Details' : 'Edit Lead' ?>
    </h1>
    <div class="mono text-muted small"><?= h($lead['ref_number']) ?></div>
  </div>
  <?php if($fromQueue): ?>
  <div>
    <?php if($lead['phone']): ?>
    <a href="tel:<?= h(preg_replace('/\D/','',$lead['phone'])) ?>"
       class="btn btn-success">
      <i class="bi bi-telephone-fill me-1"></i><?= h(format_phone($lead['phone'])) ?></a>
    <?php endif; ?>
  </div>
  <?php endif; ?>
</div>

<?php if($fromQueue): ?>
<div class="alert alert-success py-2 mb-3">
  <i class="bi bi-person-check me-2"></i>
  <strong>Customer picked up!</strong> Fill in any missing details, then use
  <strong>Save &amp; Forward to Processor</strong> if they are eligible.
</div>
<?php endif; ?>

<?php if($errors): ?>
<div class="alert alert-danger">
  <strong>Errors:</strong>
  <ul class="mb-0 mt-1"><?php foreach($errors as $e): ?><li><?= $e ?></li><?php endforeach; ?></ul>
</div>
<?php endif; ?>

<form method="post" id="leadForm">
  <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
  <input type="hidden" name="id" value="<?= $id ?>">

  <div class="row g-4">
    <div class="col-lg-8">
      <div class="card mb-4">
        <div class="card-body">
          <p class="form-section-title">Applicant Information</p>
          <div class="row g-3">
            <div class="col-md-4"><label class="form-label">First Name *</label>
              <input type="text" name="first_name" class="form-control" data-fmt="capitalize" value="<?= h($lead['first_name']) ?>" required></div>
            <div class="col-md-4"><label class="form-label">Last Name *</label>
              <input type="text" name="last_name" class="form-control" data-fmt="capitalize" value="<?= h($lead['last_name']) ?>" required></div>
            <div class="col-md-4"><label class="form-label">Date of Birth</label>
              <input type="date" name="dob" class="form-control" value="<?= h($lead['dob']) ?>"></div>
            <div class="col-md-6"><label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" value="<?= h($lead['email']) ?>"></div>
            <div class="col-md-6"><label class="form-label">Phone</label>
              <input type="text" name="phone" class="form-control" data-fmt="phone"
                     value="<?= h($lead['phone']?format_phone($lead['phone']):'') ?>"></div>
            <div class="col-md-4"><label class="form-label">SSN Last 4</label>
              <input type="text" name="ssn_last4" class="form-control mono" maxlength="4" value="<?= h($lead['ssn_last4']) ?>"></div>
          </div>
        </div>
      </div>

      <div class="card mb-4">
        <div class="card-body">
          <p class="form-section-title">Address</p>
          <div class="row g-3">
            <div class="col-12"><label class="form-label">Street</label>
              <input type="text" name="address" class="form-control" value="<?= h($lead['address']) ?>"></div>
            <div class="col-md-4"><label class="form-label">ZIP</label>
              <input type="text" name="zip" class="form-control" value="<?= h($lead['zip']) ?>"></div>
            <div class="col-md-5"><label class="form-label">City</label>
              <input type="text" name="city" class="form-control" value="<?= h($lead['city']) ?>"></div>
            <div class="col-md-3"><label class="form-label">State</label>
              <select name="state" class="form-select">
                <option value="">—</option>
                <?php foreach(us_states() as $s): ?>
                  <option value="<?= $s ?>" <?= $lead['state']===$s?'selected':'' ?>><?= $s ?></option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
        </div>
      </div>

      <div class="card mb-4">
        <div class="card-body">
          <p class="form-section-title">Financial</p>
          <div class="row g-3">
            <div class="col-md-4"><label class="form-label">Annual Income</label>
              <div class="input-group"><span class="input-group-text">$</span>
              <input type="number" name="annual_income" class="form-control" value="<?= h($lead['annual_income']) ?>"></div></div>
            <div class="col-md-4"><label class="form-label">Employment</label>
              <select name="employment_status" class="form-select">
                <option value="">—</option>
                <?php foreach(['Employed','Self-Employed','Unemployed','Retired','Student','Part-Time'] as $e): ?>
                  <option value="<?= $e ?>" <?= $lead['employment_status']===$e?'selected':'' ?>><?= $e ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-4"><label class="form-label">Credit Score Range</label>
              <select name="credit_score_range" class="form-select">
                <option value="">—</option>
                <?php foreach(['300-579 (Poor)','580-669 (Fair)','670-739 (Good)','740-799 (Very Good)','800-850 (Exceptional)'] as $r): ?>
                  <option value="<?= $r ?>" <?= $lead['credit_score_range']===$r?'selected':'' ?>><?= $r ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-4"><label class="form-label">Requested Limit</label>
              <div class="input-group"><span class="input-group-text">$</span>
              <input type="number" name="requested_limit" class="form-control" value="<?= h($lead['requested_limit']) ?>"></div></div>
            <div class="col-md-4"><label class="form-label">Card Type</label>
              <select name="card_type" class="form-select">
                <option value="">—</option>
                <?php foreach(['Visa','Mastercard','American Express','Discover','Any'] as $ct): ?>
                  <option value="<?= $ct ?>" <?= $lead['card_type']===$ct?'selected':'' ?>><?= $ct ?></option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
        </div>
      </div>

      <div class="card mb-4">
        <div class="card-body">
          <p class="form-section-title">Card / BIN</p>
          <div class="row g-3">
            <div class="col-md-5"><label class="form-label">BIN</label>
              <input type="text" name="card_number_bin" id="card_number_bin" class="form-control mono"
                     maxlength="16" value="<?= h($lead['card_number_bin']) ?>">
              <div class="mt-2" id="bin_status"></div></div>
            <div class="col-md-3"><label class="form-label">Brand</label>
              <input type="text" name="card_brand" id="card_brand" class="form-control" value="<?= h($lead['card_brand']) ?>"></div>
            <div class="col-md-4"><label class="form-label">Issuer</label>
              <input type="text" name="card_issuer" id="card_issuer" class="form-control" value="<?= h($lead['card_issuer']) ?>"></div>
            <div class="col-md-4"><label class="form-label">Type Detail</label>
              <input type="text" name="card_type_detail" id="card_type_detail" class="form-control" value="<?= h($lead['card_type_detail']) ?>"></div>
          </div>
        </div>
      </div>

      <?php if($customFields): ?>
      <div class="card mb-4">
        <div class="card-body">
          <p class="form-section-title">Additional Fields</p>
          <div class="row g-3">
            <?php foreach($customFields as $cf): $cfVal=$customVals[$cf['field_key']]??''; ?>
            <div class="col-md-<?= $cf['field_type']==='textarea'?'12':'6' ?>">
              <label class="form-label"><?= h($cf['label']) ?><?= $cf['is_required']?' *':'' ?></label>
              <?php if($cf['field_type']==='textarea'): ?>
                <textarea name="cf_<?= h($cf['field_key']) ?>" class="form-control" rows="3"><?= h($cfVal) ?></textarea>
              <?php elseif($cf['field_type']==='select'): ?>
                <select name="cf_<?= h($cf['field_key']) ?>" class="form-select">
                  <option value="">—</option>
                  <?php foreach(json_decode($cf['options']??'[]',true) as $o): ?>
                    <option value="<?= h($o) ?>" <?= $cfVal===$o?'selected':'' ?>><?= h($o) ?></option>
                  <?php endforeach; ?>
                </select>
              <?php elseif($cf['field_type']==='checkbox'): ?>
                <div class="form-check mt-2">
                  <input type="checkbox" name="cf_<?= h($cf['field_key']) ?>" class="form-check-input" value="1" <?= $cfVal?'checked':'' ?>>
                </div>
              <?php else: ?>
                <input type="<?= $cf['field_type']==='number'?'number':($cf['field_type']==='date'?'date':'text') ?>"
                       name="cf_<?= h($cf['field_key']) ?>" class="form-control" value="<?= h($cfVal) ?>">
              <?php endif; ?>
            </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
      <?php endif; ?>

      <div class="card mb-4">
        <div class="card-body">
          <p class="form-section-title">Notes</p>
          <textarea name="notes" class="form-control" rows="4"><?= h($lead['notes']) ?></textarea>
        </div>
      </div>

      <?php if($callHistory): ?>
      <div class="card mb-4">
        <div class="card-header d-flex align-items-center justify-content-between">
          <span><i class="bi bi-telephone-inbound me-2 text-primary"></i>Call History</span>
          <span class="badge bg-secondary"><?= count($callHistory) ?></span>
        </div>
        <div class="table-responsive">
          <table class="table table-sm mb-0">
            <thead><tr><th>When</th><th>Agent</th><th>Outcome</th><th>Notes</th></tr></thead>
            <tbody>
              <?php
              $outcomeLabels = [
                'no_answer'=>'No Answer','voicemail'=>'Voicemail','callback'=>'Callback',
                'picked_up'=>'Picked Up','wrong_number'=>'Wrong Number','do_not_call'=>'Do Not Call'
              ];
              $outcomeBadges = [
                'no_answer'=>'bg-secondary','voicemail'=>'bg-secondary','callback'=>'bg-warning text-dark',
                'picked_up'=>'bg-success','wrong_number'=>'bg-danger','do_not_call'=>'bg-danger'
              ];
              foreach($callHistory as $cl): ?>
              <tr>
                <td class="text-muted small mono"><?= h(date('M j Y H:i',strtotime($cl['created_at']))) ?></td>
                <td class="small"><?= h($cl['agent_name']??'—') ?></td>
                <td><span class="badge <?= $outcomeBadges[$cl['outcome']]??'bg-secondary' ?>" style="font-size:.7rem">
                  <?= h($outcomeLabels[$cl['outcome']]??$cl['outcome']) ?></span></td>
                <td class="small text-muted"><?= h($cl['notes']??'') ?></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
      <?php endif; ?>
    </div>

    <div class="col-lg-4">
      <div class="card position-sticky" style="top:1rem">
        <div class="card-body">
          <p class="form-section-title">Lead Settings</p>
          <div class="mb-3"><label class="form-label">Status</label>
            <select name="status" id="statusField" class="form-select">
              <?php foreach(['new'=>'New','in_review'=>'In Review','approved'=>'Approved','declined'=>'Declined','forwarded'=>'Forwarded','on_hold'=>'On Hold'] as $sv=>$sl): ?>
                <option value="<?= $sv ?>" <?= $lead['status']===$sv?'selected':'' ?>><?= $sl ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <?php if($user['role']!=='agent'): ?>
          <div class="mb-3"><label class="form-label">Assign To</label>
            <select name="assigned_to" class="form-select">
              <option value="">— Unassigned —</option>
              <?php foreach($processors as $p): ?>
                <option value="<?= $p['id'] ?>" <?= $lead['assigned_to']==$p['id']?'selected':'' ?>>
                  <?= h($p['full_name']?:$p['username']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <?php endif; ?>
          <hr>
          <div class="d-grid gap-2">
            <?php if($fromQueue || $user['role']==='agent'): ?>
            <button type="submit" name="save_and_forward" value="1" class="btn btn-info"
              onclick="document.getElementById('statusField').value='forwarded'"
              title="Save all details and immediately forward this lead to the processing queue">
              <i class="bi bi-send me-1"></i>Save &amp; Forward to Processor</button>
            <?php endif; ?>
            <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>Save Changes</button>
            <a href="<?= $fromQueue ? APP_URL.'/modules/leads/call_queue.php' : APP_URL.'/modules/leads/view.php?id='.$id ?>"
               class="btn btn-outline-secondary">Cancel</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</form>

<?php include __DIR__.'/../../includes/layout_footer.php'; ?>
