<?php
require_once __DIR__.'/../../config/config.php';
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/auth.php';
require_once __DIR__.'/../../includes/helpers.php';
session_start_secure();
require_login();

// CSRF via GET param
$csrf = $_GET['csrf'] ?? '';
if (!hash_equals($_SESSION['csrf_token'] ?? '', $csrf)) {
    http_response_code(403); die('Invalid token.');
}

$idsRaw = $_GET['ids'] ?? '';
$ids = array_filter(array_map('intval', explode(',', $idsRaw)));
if (!$ids) { die('No IDs.'); }

// Limit to 5000 for selected export
$ids = array_slice($ids, 0, 5000);
$in  = implode(',', $ids);

$customFields = get_custom_fields();

$st = db()->query("SELECT l.*, u.full_name AS agent_name, u.username AS agent_username
    FROM leads l LEFT JOIN users u ON u.id=l.agent_id WHERE l.id IN ($in) ORDER BY l.created_at DESC");
$leads = $st->fetchAll();

if ($leads && $customFields) {
    $cvRows = db()->query("SELECT lcv.lead_id,cf.field_key,lcv.value FROM lead_custom_values lcv
        JOIN custom_fields cf ON cf.id=lcv.custom_field_id WHERE lcv.lead_id IN ($in)")->fetchAll();
    $cvMap = [];
    foreach ($cvRows as $r) $cvMap[$r['lead_id']][$r['field_key']] = $r['value'];
    foreach ($leads as &$l) foreach ($customFields as $cf) $l['cv_'.$cf['field_key']] = $cvMap[$l['id']][$cf['field_key']] ?? '';
    unset($l);
}

audit('leads_export_selected','lead',null,'Exported '.count($leads).' selected leads');
export_leads_csv($leads, $customFields);
