<?php
require_once __DIR__.'/../../config/config.php';
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/auth.php';
require_once __DIR__.'/../../includes/helpers.php';
session_start_secure();
require_login();

$user = current_user();
$id   = (int)($_GET['id']??0);
if (!$id) { flash('error','Invalid lead.'); redirect(APP_URL.'/modules/leads/index.php'); }

$st = db()->prepare("SELECT l.*,u.full_name as agent_name,u.username as agent_user,
    a.full_name as assigned_name FROM leads l
    LEFT JOIN users u ON u.id=l.agent_id
    LEFT JOIN users a ON a.id=l.assigned_to
    WHERE l.id=?");
$st->execute([$id]);
$lead = $st->fetch();
if (!$lead) { flash('error','Lead not found.'); redirect(APP_URL.'/modules/leads/index.php'); }

// Agents can only see their own leads
if ($user['role']==='agent' && $lead['agent_id']!=$user['id']) {
    http_response_code(403); die('Access denied.');
}

// Handle forward action (supports both normal POST and AJAX from call queue)
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['action'])) {
    csrf_check();
    if ($_POST['action']==='forward') {
        db()->prepare("UPDATE leads SET status='forwarded',forwarded_at=NOW() WHERE id=?")->execute([$id]);
        audit('lead_forwarded','lead',$id);
        if (!empty($_POST['ajax'])) {
            header('Content-Type: application/json');
            echo json_encode(['ok'=>true]);
            exit;
        }
        flash('success','Lead forwarded to processing.');
        redirect(APP_URL.'/modules/leads/view.php?id='.$id);
    }
}

$customFields = get_custom_fields();
$customVals   = get_lead_custom_values($id);
$history      = db()->prepare("SELECT al.*,u.full_name FROM audit_log al LEFT JOIN users u ON u.id=al.user_id WHERE al.entity_type='lead' AND al.entity_id=? ORDER BY al.created_at DESC");
$history->execute([$id]);
$history = $history->fetchAll();

$pageTitle = 'Lead: '.h($lead['first_name'].' '.$lead['last_name']);
include __DIR__.'/../../includes/layout_header.php';
?>

<div class="page-header d-flex align-items-start justify-content-between flex-wrap gap-2">
  <div>
    <div class="d-flex align-items-center gap-2 mb-1">
      <a href="<?= APP_URL ?>/modules/leads/index.php" class="text-muted text-decoration-none small">
        <i class="bi bi-arrow-left"></i> Leads</a>
    </div>
    <h1><?= h($lead['first_name'].' '.$lead['last_name']) ?></h1>
    <div class="d-flex align-items-center gap-2 flex-wrap">
      <span class="mono text-muted small"><?= h($lead['ref_number']) ?></span>
      <?= status_badge($lead['status']) ?>
      <?php if($lead['card_brand']): ?>
        <span class="tag"><i class="bi bi-credit-card"></i> <?= h(ucfirst($lead['card_brand'])) ?></span>
      <?php endif; ?>
    </div>
  </div>
  <div class="d-flex gap-2 flex-wrap">
    <?php if($lead['status']!=='forwarded' && ($user['role']==='admin'||$user['role']==='agent')): ?>
    <form method="post" class="d-inline">
      <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
      <input type="hidden" name="action" value="forward">
      <button type="submit" class="btn btn-info btn-sm" onclick="return confirm('Forward this lead to processing?')">
        <i class="bi bi-send me-1"></i>Forward to Processing</button>
    </form>
    <?php endif; ?>
    <a href="<?= APP_URL ?>/modules/leads/edit.php?id=<?= $id ?>" class="btn btn-primary btn-sm">
      <i class="bi bi-pencil me-1"></i>Edit</a>
  </div>
</div>

<div class="row g-4">
  <!-- Left detail column -->
  <div class="col-lg-8">

    <!-- Personal Info -->
    <div class="card mb-4">
      <div class="card-header">Applicant Information</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-4"><div class="form-label text-muted">Full Name</div><div class="fw-medium"><?= h($lead['first_name'].' '.$lead['last_name']) ?></div></div>
          <div class="col-md-4"><div class="form-label text-muted">Date of Birth</div><div><?= $lead['dob'] ? h(date('M j, Y',strtotime($lead['dob']))) : '—' ?></div></div>
          <div class="col-md-4"><div class="form-label text-muted">SSN Last 4</div><div class="mono"><?= $lead['ssn_last4'] ? '***-**-'.h($lead['ssn_last4']) : '—' ?></div></div>
          <div class="col-md-6"><div class="form-label text-muted">Email</div>
            <div><?= $lead['email'] ? '<a href="mailto:'.h($lead['email']).'">'.h($lead['email']).'</a>' : '—' ?></div></div>
          <div class="col-md-6"><div class="form-label text-muted">Phone</div>
            <div class="mono"><?= $lead['phone'] ? '<a href="tel:'.h($lead['phone']).'">'.h(format_phone($lead['phone'])).'</a>' : '—' ?></div></div>
          <div class="col-12"><div class="form-label text-muted">Address</div>
            <div><?= array_filter([$lead['address'],$lead['city'].($lead['state']?', '.$lead['state']:'')?:null,$lead['zip']])
                      ? h(implode(', ',array_filter([$lead['address'],$lead['city'].($lead['state']?', '.$lead['state']:'')?:$lead['city'],$lead['zip']]))) : '—' ?></div></div>
        </div>
      </div>
    </div>

    <!-- Financial Info -->
    <div class="card mb-4">
      <div class="card-header">Financial Information</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-4"><div class="form-label text-muted">Annual Income</div><div><?= format_currency($lead['annual_income']) ?></div></div>
          <div class="col-md-4"><div class="form-label text-muted">Employment</div><div><?= h($lead['employment_status']?:'—') ?></div></div>
          <div class="col-md-4"><div class="form-label text-muted">Credit Score</div><div><?= h($lead['credit_score_range']?:'—') ?></div></div>
          <div class="col-md-4"><div class="form-label text-muted">Requested Limit</div><div><?= format_currency($lead['requested_limit']) ?></div></div>
          <div class="col-md-4"><div class="form-label text-muted">Card Type</div><div><?= h($lead['card_type']?:'—') ?></div></div>
        </div>
      </div>
    </div>

    <!-- Card / BIN -->
    <div class="card mb-4">
      <div class="card-header">Card / BIN Information</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-4"><div class="form-label text-muted">BIN</div><div class="mono fw-medium"><?= h($lead['card_number_bin']?:'—') ?></div></div>
          <div class="col-md-4"><div class="form-label text-muted">Brand</div><div><?= $lead['card_brand'] ? '<span class="tag"><i class="bi bi-credit-card"></i> '.h(ucfirst($lead['card_brand'])).'</span>' : '—' ?></div></div>
          <div class="col-md-4"><div class="form-label text-muted">Type</div><div><?= h($lead['card_type_detail']?:'—') ?></div></div>
          <div class="col-md-8"><div class="form-label text-muted">Issuer / Bank</div><div><?= h($lead['card_issuer']?:'—') ?></div></div>
        </div>
      </div>
    </div>

    <?php if($customFields): ?>
    <div class="card mb-4">
      <div class="card-header">Additional Fields</div>
      <div class="card-body">
        <div class="row g-3">
          <?php foreach($customFields as $cf): ?>
          <div class="col-md-6">
            <div class="form-label text-muted"><?= h($cf['label']) ?></div>
            <div><?= h($customVals[$cf['field_key']] ?? '—') ?></div>
          </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
    <?php endif; ?>

    <?php if($lead['notes']): ?>
    <div class="card mb-4">
      <div class="card-header">Notes</div>
      <div class="card-body"><p class="mb-0" style="white-space:pre-wrap"><?= h($lead['notes']) ?></p></div>
    </div>
    <?php endif; ?>

    <!-- History -->
    <div class="card">
      <div class="card-header"><i class="bi bi-clock-history me-2"></i>Change History</div>
      <div class="table-responsive">
        <table class="table table-sm mb-0">
          <thead><tr><th>Time</th><th>User</th><th>Action</th><th>Details</th></tr></thead>
          <tbody>
            <?php foreach($history as $h_): ?>
            <tr>
              <td class="text-muted small mono"><?= h(date('M j Y H:i',strtotime($h_['created_at']))) ?></td>
              <td class="small"><?= h($h_['full_name']?:$h_['username']?:'System') ?></td>
              <td><span class="tag"><?= h($h_['action']) ?></span></td>
              <td class="text-muted small"><?= h($h_['details']?:'') ?></td>
            </tr>
            <?php endforeach; ?>
            <?php if(!$history): ?>
              <tr><td colspan="4" class="text-center text-muted py-3">No history.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <!-- Right sidebar -->
  <div class="col-lg-4">
    <div class="card mb-4">
      <div class="card-header">Lead Details</div>
      <div class="card-body">
        <div class="mb-3"><div class="form-label text-muted">Reference</div><div class="mono fw-bold"><?= h($lead['ref_number']) ?></div></div>
        <div class="mb-3"><div class="form-label text-muted">Status</div><?= status_badge($lead['status']) ?></div>
        <div class="mb-3"><div class="form-label text-muted">Agent</div><div><?= h($lead['agent_name']?:$lead['agent_user']?:'—') ?></div></div>
        <div class="mb-3"><div class="form-label text-muted">Assigned To</div><div><?= h($lead['assigned_name']?:'Unassigned') ?></div></div>
        <div class="mb-3"><div class="form-label text-muted">Created</div><div><?= h(date('M j, Y g:ia',strtotime($lead['created_at']))) ?></div></div>
        <?php if($lead['forwarded_at']): ?>
        <div class="mb-3"><div class="form-label text-muted">Forwarded</div><div><?= h(date('M j, Y g:ia',strtotime($lead['forwarded_at']))) ?></div></div>
        <?php endif; ?>
        <div><div class="form-label text-muted">Last Updated</div><div><?= h(date('M j, Y g:ia',strtotime($lead['updated_at']))) ?></div></div>
      </div>
    </div>
    <?php if($user['role']==='admin'): ?>
    <div class="card border-danger">
      <div class="card-body">
        <p class="form-section-title text-danger">Danger Zone</p>
        <form method="post" action="<?= APP_URL ?>/modules/leads/delete.php">
          <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
          <input type="hidden" name="id" value="<?= $id ?>">
          <button type="submit" class="btn btn-outline-danger btn-sm w-100"
            data-confirm="Permanently delete this lead? This cannot be undone.">
            <i class="bi bi-trash me-1"></i>Delete Lead</button>
        </form>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>

<?php include __DIR__.'/../../includes/layout_footer.php'; ?>
